<?php

namespace App\Tests\Controller;

use App\Entity\Submenu;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

final class SubmenuControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private EntityManagerInterface $manager;
    private EntityRepository $repository;
    private string $path = '/admin/submenu/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->manager = static::getContainer()->get('doctrine')->getManager();
        $this->repository = $this->manager->getRepository(Submenu::class);

        foreach ($this->repository->findAll() as $object) {
            $this->manager->remove($object);
        }

        $this->manager->flush();
    }

    public function testIndex(): void
    {
        $this->client->followRedirects();
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Submenu index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'submenu[title]' => 'Testing',
            'submenu[isEnabled]' => 'Testing',
            'submenu[rank]' => 'Testing',
            'submenu[menu]' => 'Testing',
        ]);

        self::assertResponseRedirects($this->path);

        self::assertSame(1, $this->repository->count([]));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new Submenu();
        $fixture->setTitle('My Title');
        $fixture->setIsEnabled('My Title');
        $fixture->setRank('My Title');
        $fixture->setMenu('My Title');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Submenu');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new Submenu();
        $fixture->setTitle('Value');
        $fixture->setIsEnabled('Value');
        $fixture->setRank('Value');
        $fixture->setMenu('Value');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'submenu[title]' => 'Something New',
            'submenu[isEnabled]' => 'Something New',
            'submenu[rank]' => 'Something New',
            'submenu[menu]' => 'Something New',
        ]);

        self::assertResponseRedirects('/admin/submenu/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getTitle());
        self::assertSame('Something New', $fixture[0]->getIsEnabled());
        self::assertSame('Something New', $fixture[0]->getRank());
        self::assertSame('Something New', $fixture[0]->getMenu());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();
        $fixture = new Submenu();
        $fixture->setTitle('Value');
        $fixture->setIsEnabled('Value');
        $fixture->setRank('Value');
        $fixture->setMenu('Value');

        $this->manager->persist($fixture);
        $this->manager->flush();

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertResponseRedirects('/admin/submenu/');
        self::assertSame(0, $this->repository->count([]));
    }
}
