<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use App\Repository\MenuRepository;
use Doctrine\Common\Collections\Collection;
use Gedmo\Mapping\Annotation\SortablePosition;
use Doctrine\Common\Collections\ArrayCollection;

#[ORM\Entity(repositoryClass: MenuRepository::class)]
class Menu
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $title = null;

    #[ORM\Column]
    private ?bool $isEnabled = null;

    #[ORM\Column]
    #[SortablePosition]
    private ?int $rank = null;

    /**
     * @var Collection<int, Submenu>
     */
    #[ORM\OneToMany(targetEntity: Submenu::class, mappedBy: 'menu', orphanRemoval: true)]
    private Collection $submenus;

    public function __construct()
    {
        $this->submenus = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): static
    {
        $this->title = $title;

        return $this;
    }

    public function getIsEnabled(): ?bool
    {
        return $this->isEnabled;
    }

    public function setIsEnabled(bool $isEnabled): static
    {
        $this->isEnabled = $isEnabled;

        return $this;
    }

    public function getRank(): ?int
    {
        return $this->rank;
    }

    public function setRank(int $rank): static
    {
        $this->rank = $rank;

        return $this;
    }

    /**
     * @return Collection<int, Submenu>
     */
    public function getSubmenus(): Collection
    {
        return $this->submenus;
    }

    public function addSubmenu(Submenu $submenu): static
    {
        if (!$this->submenus->contains($submenu)) {
            $this->submenus->add($submenu);
            $submenu->setMenu($this);
        }

        return $this;
    }

    public function removeSubmenu(Submenu $submenu): static
    {
        if ($this->submenus->removeElement($submenu)) {
            // set the owning side to null (unless already changed)
            if ($submenu->getMenu() === $this) {
                $submenu->setMenu(null);
            }
        }

        return $this;
    }
}
