<?php

namespace App\Entity;

use App\Repository\PageRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PageRepository::class)]
class Page
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'pages')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Submenu $submenu = null;

    #[ORM\Column(length: 255)]
    private ?string $title = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $description = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $image = null;

    #[ORM\Column]
    private ?bool $isEnabled = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $secondSection = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMenu(): ?Menu 
    {
        return $this->submenu?->getMenu();
    }

    public function setMenu(Menu $menu): static
    {
        return $this;
    }

    public function getSubmenu(): ?Submenu
    {
        return $this->submenu;
    }

    public function setSubmenu(?Submenu $submenu): static
    {
        $this->submenu = $submenu;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): static
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): static
    {
        $this->image = $image;

        return $this;
    }

    public function getIsEnabled(): ?bool
    {
        return $this->isEnabled;
    }

    public function setIsEnabled(bool $isEnabled): static
    {
        $this->isEnabled = $isEnabled;

        return $this;
    }

    public function getSecondSection(): ?string
    {
        return $this->secondSection;
    }

    public function setSecondSection(?string $secondSection): static
    {
        $this->secondSection = $secondSection;

        return $this;
    }
}
